*-----------------------------------------------------------
* Program    :	ASCII Character Set, UNICODE not supported now
* Written by :
* Date       :
* Description: Type Char
*-----------------------------------------------------------
*	Type	Char
Char_NUL	equ	$00	* *@
Char_SOH	equ	$01	* ^A
Char_STX	equ	$02	* ^B
Char_ETX	equ	$03	* ^C
Char_EOT	equ	$04	* ^D
Char_ENQ	equ	$05	* ^E
Char_ACK	equ	$06	* ^F
Char_BEL	equ	$07	* ^G
Char_BS		equ	$08	* ^H
Char_HT		equ	$09	* ^I
Char_LF		equ	$0A	* ^J
Char_VT		equ	$0B	* ^K
Char_FF		equ	$0C	* ^L
Char_CR		equ	$0D	* ^M
Char_SO		equ	$0e	* ^N
Char_SI		equ	$0f	* ^O
Char_DLE	equ	$10	* ^P
*
Char_DC1	equ	$11	* ^Q
Char_DC2	equ	$12	* ^R
Char_DC3	equ	$13	* ^S
Char_DC4	equ	$14	* ^T
Char_NAK	equ	$15	* ^U
Char_SYN	equ	$16	* ^V
Char_ETB	equ	$17	* ^W
Char_CAN	equ	$18	* ^X
Char_EM		equ	$19	* ^Y
Char_SUB	equ	$1A	* ^Z
Char_ESC	equ	$1B	* ^[
Char_FS		equ	$1C	* ^\
Char_GS		equ	$1D	* ^]
Char_RS		equ	$1E	* ^^
Char_US		equ	$1F	* ^_
Char_SPACE	equ	' '
*
Char_BANG	equ	'!'
Char_DBLQUOTE	equ	'"'
Char_POUND	equ	'#'
Char_DOLLAR	equ	'$'
Char_PCT	equ	'%'
Char_AMPER	equ	'&'
Char_RQUOTE	equ	''''
Char_LPAREN	equ	'('
Char_RPAREN	equ	')'
Char_STAR	equ	'*'
Char_PLUS	equ	'+'
Char_COMMA	equ	','
Char_MINUS	equ	'-'
Char_DOT	equ	'.'
Char_SLASH	equ	'/'
Char_COLON	equ	':'
Char_SEMI	equ	';'
*
Char_LT		equ	'<'
Char_EQUAL	equ	'='
Char_GT		equ	'>'
Char_QMARK	equ	'?'

Char_AT		equ	'@'
Char_LBRACK	equ	'['
Char_BKSLASH	equ	'\'
Char_RBRACK	equ	']'
Char_UPARROW	equ	'^'
Char_UNDERSCORE	equ	'_'
Char_LQUOTE	equ	'`'
Char_LBRACE	equ	'{'
Char_VBAR	equ	'|'
Char_RBRACE	equ	'}'
Char_TILDE	equ	'~'
Char_DEL	equ	$7F
*
* =================== CharHexVal (ch): long ====================
CharHexVal:
*    if ch >= '0' then if ch <= '9' then return ch-'0'
*	else if ch >= 'A' then if ch <= 'F' then return ch+10-'A'
*	  else if ch >= 'a' then if ch <= 'f' then return ch+10-'a'
*    return -1;
	move.l	LNGBYTS(a7),d0
	move.l	#'0',d1
	cmp.l	d1,d0
	blt	cdv1
	  cmpi.l #'9',d0
	  bgt	chv1
	  sub.l	d1,d0
	bra   cdv2
chv1:
        move.l  #'A',d1
        cmp.l	d1,d0
        blt	cdv1
           cmpi.l #'F',d0
           bgt  chv2
chv3:
           addi.l #10,d0
           sub.l d1,d0
        bra	cdv2
chv2:
	move.l	#'a',d1
	cmp.l	d1,d0
	blt	cdv1
	   cmpi.l #'f',d0
	   ble  chv3
	bra 	cdv1
*
* ================= CharDecVal (ch): long ==================
CharDecVal:
*     if ch >= '0' then if ch <= '9' then return ch-'0';
*     return -1;
	move.l	LNGBYTS(a7),d0
	move.l	#'0',d1
	cmp.l	d1,d0
	blt	cdv1
	  cmpi.l  #'9',d0
	  bgt   cdv1
	  sub.l d1,d0
	  bra	cdv2
cdv1:
	move.l	#-1,d0
cdv2:
	move.l d0,(a6)
	rts
*
* ================ CharAsc (i):ch ==========================
CharAsc:
*     i=i & 15;
*     if i>= 0 then if i <= 9 then return i+'0'
*     else return i+'A'-10;
	moveq.l	#NIBMSK,d0
	and.l	-MARKBYTS(a6),d0
	cmpi.l	#9,d0
	bgt     catry10
	move.l	#'0',d1
	add.l	d1,d0
	bra	cdv2
catry10:
	move.l	#'A',d1
	add.l	d1,d0
	sub.l	#10,d0
	bra	cdv2
*
* =============== CharUC(ch):ch ============================
CharUC:
*     if ch>= 'a' then if ch <= 'z' then return'A'+ch-'a' 
*     return ch
	move.l	LNGBYTS(a7),d0
	cmpi.l	#'a',d0
	bge 	cucok
	bra	cdv2
cucok:
	cmpi.l	#'z',d0
	bgt	cdv2
	add.l	#'A',d0
	sub.l	#'a',d0
	bra	cdv2
*
* ================ CharLC(ch):ch ===========================
CharLC:
*     if ch>='A' then if ch <= 'Z' then return 'a'+ch-'A'
*     return ch
	move.l	LNGBYTS(a7),d0
	cmpi.l	#'A',d0
	bge 	clcok
	bra	cdv2
clcok:
	cmpi.l	#'Z',d0
	bgt	cdv2
	add.l	#'a',d0
	sub.l	#'A',d0
	bra	cdv2
*
* ================ CharCtl (ch):ch =========================
CharCtl:
*     if ch>= '@' then if ch <= '_' then return ch-'@'
*     return ch
	move.l	LNGBYTS(a7),d0
	cmpi.l	#'@',d0
	bge 	ccok
	bra	cdv2
ccok:
	cmpi.l	#'_',d0
	bgt	cdv2
	sub.l	#'@',d0
	bra	cdv2
*
* ================= CharVs (ch): ch ========================	
* Turns undisplayable ch's into dots
CharVs:		* Alters: d0
*	d0 = ch
	move.l	-LNGBYTS(a6),d0
*	result = '.'
	move.l	#Char_DOT,(a6)
*	if ch == DEL then goto charvisret
	cmpi.l	#Char_DEL,d0
	beq	charvisret
*	else if ch < ' ' then goto charvisret
	cmpi.l	#Char_SPACE,d0
	blt	charvisret
*		result = ch
	move.l	d0,(a6)
*	endif
charvisret:
*	return
	rts
*
*	======================= Name Vectors =================
*
_CharHexVal	DC.L	0
		DC.W	12
		DC.W	11
		DC.B	'_CharHexVal',0,0,0,0,0
*
_CharDecVal	DC.L	_CharHexVal
		DC.W	12
		DC.W	11
		DC.B	'_CharDecVal',0,0,0,0,0
*
_CharAsc	DC.L	_CharDecVal
		DC.W	12
		DC.W	8
		DC.B	'_CharAsc',0,0,0,0,0,0,0,0
*
_CharUC		DC.L	_CharAsc
		DC.W	8
		DC.W	7
		DC.B	'_CharUC',0
*
_CharLC		DC.L	_CharUC
		DC.W	8
		DC.W	7
		DC.B	'_CharLC',0
*
_CharCtl	DC.L	_CharLC
		DC.W	12
		DC.W	8
		DC.B	'_CharCtl',0,0,0,0,0,0,0,0
*
_CharVs		DC.L	_CharVs
		DC.W	8
		DC.W	7
		DC.B	'_CharVs',0
*
*	=================== Dic Entries ======================
*
__CharHexVal	DC.L	0
		DC.L	_CharHexVal
		DC.L	CharHexVal
*
__CharDecVal	DC.L	__CharHexVal
		DC.L	_CharDecVal
		DC.L	CharDecVal
*
__CharAsc	DC.L	__CharDecVal
		DC.L	_CharAsc
		DC.L	CharAsc
*
__CharUC	DC.L	__CharAsc
		DC.L	_CharAsc
		DC.L	CharAsc
*
__CharLC	DC.L	__CharUC
		DC.L	_CharLC
		DC.L	CharLC
*
__CharVs	DC.L	__CharLC
		DC.L	_CharVs
		DC.L	CharVs
*
__CharCtl	DC.L	__CharVs
		DC.L	_CharCtl
		DC.L	CharCtl
*




























*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
